/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!****************************************************************!*\
  !*** ./resources/js/design_1/parts/profile_reserve_meeting.js ***!
  \****************************************************************/
(function ($) {
  "use strict";

  /*******
   * Calendar
   *  */
  function handleShowDay(unix) {
    var day = new persianDate(unix).day();
    var startDayTime = new persianDate(unix).startOf('day').unix();
    var endDayTime = new persianDate(unix).endOf('day').unix();
    var showThisDay = false;

    // availableDays is defined globally in blade

    for (var index2 in availableDays) {
      var disabled_day = Number(availableDays[index2]);
      if (disabled_day === day) {
        showThisDay = true;
      }
    }
    return showThisDay;
  }
  function handlePDatepicker() {
    $(".inline-reservation-calender").pDatepicker({
      inline: true,
      altField: '#inlineCalender',
      initialValue: true,
      calendarType: typeof appLocale !== "undefined" && (appLocale === "fa" || appLocale === "FA") ? 'persian' : 'gregorian',
      initialValueType: true,
      autoClose: true,
      altFormat: 'DD MMMM YY',
      calendar: {
        gregorian: {
          locale: 'en'
        },
        persian: {
          locale: 'fa'
        }
      },
      toolbox: {
        calendarSwitch: {
          enabled: false
        }
      },
      navigator: {
        scroll: {
          enabled: false
        },
        text: {
          btnNextText: '<',
          btnPrevText: ">"
        }
      },
      minDate: new persianDate().subtract('day', 0).valueOf(),
      checkDate: function checkDate(unix) {
        return handleShowDay(unix);
      },
      timePicker: {
        enabled: false
      },
      onSelect: function onSelect(unix) {
        var pDate = new persianDate(unix);
        var timestamp = pDate.startOf('day').unix();
        var dayLabel = pDate.format('dddd');
        var date = pDate.format('YYYY-MM-DD');
        $('#selectedDay').val(date);
        handleShowReservationTimes(timestamp, dayLabel, date);
      }
    });
  }
  if ($(".inline-reservation-calender").length) {
    handlePDatepicker();
  }
  function handleShowReservationTimes(timestamp, dayLabel, date) {
    var $beforeSelect = $('.js-before-select-day-card');
    var $container = $('.js-times-container');
    var $body = $container.find('.js-times-body');
    var availableTimes = $('#availableTimes');
    var $loading = $container.find('.js-loading-img');
    var username = $container.attr('data-user');
    $beforeSelect.removeClass('d-flex').addClass('d-none');
    $container.removeClass('d-none').addClass('d-flex');
    $body.addClass('d-none').removeClass('d-flex');
    $loading.removeClass('d-none').addClass('d-flex');
    $container.find('.js-selected-date').text($('#inlineCalender').val());
    $('input[name="date"]').val(timestamp);
    var path = "/users/".concat(username, "/availableTimes");
    var data = {
      timestamp: timestamp,
      day_label: dayLabel,
      date: date
    };
    $.post(path, data, function (result) {
      var html = '';
      if (result && typeof result.times !== "undefined") {
        Object.keys(result.times).forEach(function (key) {
          var item = result.times[key];
          if (item.time) {
            var times = item.time.split('-');
            if (times.length === 2) {
              html += "<div class=\"profile-available-times-item\">\n                                    <input type=\"radio\" name=\"time\" id=\"availableTime_".concat(item.id, "\" value=\"").concat(item.id, "\" ").concat(item.can_reserve ? '' : 'disabled', " data-type=\"").concat(item.meeting_type, "\">\n                                    <label for=\"availableTime_").concat(item.id, "\" class=\"d-flex align-items-center p-12 rounded-12 font-14 font-weight-bold ").concat(item.can_reserve ? '' : 'unavailable', "\">\n                                        <span class=\"\">").concat(times[0], "</span>\n                                        <div class=\"time-center-divider position-relative d-flex-center size-16 rounded-circle mx-24\">\n                                            <x-iconsax-bul-teacher class=\"icons\" width=\"12px\" height=\"12px\"/>\n                                        </div>\n                                        <span class=\"\">").concat(times[1], "</span>\n                                    </label>\n\n                                    <input type=\"hidden\" class=\"js-time-description\" value=\"").concat(item.description, "\"/>\n                                </div>");
            }
          }
        });
      }
      availableTimes.html(html);
    }).always(function () {
      $body.removeClass('d-none').addClass('d-flex');
      $loading.removeClass('d-flex').addClass('d-none');
    });
  }
  $('body').on('change', 'input[name="time"]', function (e) {
    if (this.checked) {
      var $body = $('.js-times-body');
      var $this = $(this);
      var type = $this.attr('data-type');

      // Show Time Description
      var $timeDescription = $this.parent().find('.js-time-description');
      var $timeDescriptionCard = $('.js-time-description-card');
      if ($timeDescription && $timeDescription.val() && $timeDescription.val() !== 'null' && $timeDescription.val() !== 'undefined') {
        $timeDescriptionCard.removeClass('d-none');
        $timeDescriptionCard.text($timeDescription.val());
      } else {
        $timeDescriptionCard.addClass('d-none');
      }

      // Show Proceed Button
      $('.js-reserve-btn').removeClass('d-none');
    }
  });
  $('body').on('click', '.js-proceed-to-booking-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var data = $form.serializeObject();
    var path = $form.attr("action");
    path += "?date=".concat(data['date'], "&time=").concat(data['time']);
    $this.addClass('loadingbar').prop('disabled', true);
    window.location.href = path;
  });
})(jQuery);
/******/ })()
;